#include <iostream>
#include <vector>
#include <map>
#include <cmath>
#include <algorithm>
#include <utility>
#include <set>

using namespace std;

struct Point {
    double x, y;
    int idx;
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n;
    double eps;
    cin >> n >> eps;
    
    vector<Point> points(n);
    for (int i = 0; i < n; i++) {
        cin >> points[i].x >> points[i].y;
        points[i].idx = i + 1;
    }
    
    // ???????? ??????
    double cell_size = eps / 2.0;
    
    // ???? ???? ?? ???? (??????_x, ??????_y) ???? ?????? ????? ?? ?? ??????
    map<pair<int, int>, int> cell_to_point;
    // ???? ???? ???? ?????????? ????????? ??????
    map<int, pair<double, double>> selected_points;
    
    for (const auto& p : points) {
        int cell_x = static_cast<int>(floor(p.x / cell_size));
        int cell_y = static_cast<int>(floor(p.y / cell_size));
        pair<int, int> cell = {cell_x, cell_y};
        
        if (cell_to_point.find(cell) == cell_to_point.end()) {
            cell_to_point[cell] = p.idx;
            selected_points[p.idx] = {p.x, p.y};
        }
    }
    
    // Q ?? ???????? ???????
    vector<int> Q;
    for (const auto& entry : cell_to_point) {
        Q.push_back(entry.second);
    }
    
    // ????? Q
    cout << Q.size() << "\n";
    for (size_t i = 0; i < Q.size(); i++) {
        cout << Q[i];
        if (i < Q.size() - 1) cout << " ";
    }
    cout << "\n";
    
    // ???????????? ?????? - ?????????? ????? ???? ?? ? ???????? ????????
    // ???? ????????? ????? ?????? ?? ??????? ???????
    vector<pair<pair<int, int>, int>> cells_with_points;
    for (const auto& entry : cell_to_point) {
        cells_with_points.push_back({entry.first, entry.second});
    }
    
    // ???????? ?????? ?? x ?? ?? y ?? ????? ???????? ???????
    sort(cells_with_points.begin(), cells_with_points.end(),
         [](const pair<pair<int, int>, int>& a, const pair<pair<int, int>, int>& b) {
             if (a.first.first != b.first.first) 
                 return a.first.first < b.first.first;
             return a.first.second < b.first.second;
         });
    
    // ?????? ????? ? ???????? ???????? (?????????????)
    vector<pair<int, int>> edges;
    set<int> used;
    
    for (size_t i = 0; i < cells_with_points.size(); i++) {
        int idx1 = cells_with_points[i].second;
        
        // ??????? ?? ?? ?? ????? ??? ????????
        if (used.size() == Q.size()) break;
        
        // ??????? ?? ??????? ?? ???????? ? ???? (??? ???????)
        if (i + 1 < cells_with_points.size()) {
            int idx2 = cells_with_points[i + 1].second;
            // ??????? ?? ?? ?? ?????? ??????? (? L8 ??????)
            auto cell1 = cells_with_points[i].first;
            auto cell2 = cells_with_points[i + 1].first;
            
            int dx = abs(cell1.first - cell2.first);
            int dy = abs(cell1.second - cell2.second);
            
            // ??? ?? ?????? ??????? (?????????? ??????????? ??????)
            if (max(dx, dy) <= 1) {
                edges.push_back({idx1, idx2});
                used.insert(idx1);
                used.insert(idx2);
            }
        }
    }
    
    // ??? ???? ??????? ?????, ????? ??? ?? ?? ???? ??????
    // ??????????? ???????: ?????? ??? ? ????? ?? ????????? ? Q
    if (edges.size() < Q.size() - 1) {
        edges.clear();
        for (size_t i = 0; i < Q.size() - 1; i++) {
            edges.push_back({Q[i], Q[i + 1]});
        }
    }
    
    // ????? ?????
    for (const auto& edge : edges) {
        cout << edge.first << " " << edge.second << "\n";
    }
    
    return 0;
}